<?php include 'loader.php'; ?>
<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>
<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Products Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li>
                <a href="<?php echo SITE_ADMIN; ?>index.php"><i class="fa fa-bar-chart"></i> Anasayfa</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>orders.php"><i class="gi gi-shop_window"></i> Siparişler</a>
            </li>
            <li class="active">
                <a href="<?php echo SITE_ADMIN; ?>tickets.php"><i class="fa fa-ticket"></i> Biletler</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Products Header -->

    <!-- Quick Stats -->
    <div class="row text-center">
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-success">
                    <h4 class="widget-content-light"><strong>Yeni Bilet</strong> Ekle</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 text-success animation-expandOpen"><i class="fa fa-plus"></i></span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-danger">
                    <h4 class="widget-content-light"><strong>Basılan</strong> Bilet</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 text-danger animation-expandOpen">
                      <?php
                      $orders = $db->query("SELECT count(ot.ticket_id) as total FROM ".DBPREFIX."order_ticket ot LEFT JOIN ".DBPREFIX."order o ON (o.id=ot.order_id) WHERE o.order_status='1' AND ot.ticket_number<>''");
                      echo $orders->row['total'];
                      ?>
                    </span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Beklemede Olan</strong> Biletler</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">
                        <?php
                        $orders = $db->query("SELECT count(ot.ticket_id) as total FROM ".DBPREFIX."order_ticket ot LEFT JOIN ".DBPREFIX."order o ON (o.id=ot.order_id) WHERE o.order_status='1' AND ot.ticket_number=''");
                        echo $orders->row['total'];
                        ?>
                    </span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Toplam</strong> Bilet</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">
                        <?php
                        $orders = $db->query("SELECT count(ot.ticket_id) as total FROM ".DBPREFIX."order_ticket ot LEFT JOIN ".DBPREFIX."order o ON (o.id=ot.order_id) WHERE o.order_status='1'");
                        echo $orders->row['total'];
                        ?>
                    </span></div>
            </a>
        </div>
    </div>
    <!-- END Quick Stats -->

    <!-- All Products Block -->
    <div class="block full">
        <!-- All Products Title -->
        <div class="block-title">
            <div class="block-options pull-right">
                <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Settings"><i class="fa fa-cog"></i></a>
            </div>
            <h2><strong>Tüm</strong> Biletler</h2>
        </div>
        <!-- END All Products Title -->

        <!-- All Products Content -->
        <table id="ecom-products" class="table table-bordered table-striped table-vcenter">
            <thead>
                <tr>
                    <th class="text-center" style="width: 70px;">ID</th>
                    <th>Bilet Sahibi</th>
                    <th class="text-right hidden-xs">Fiyat</th>
                    <th class="hidden-xs">Bilet Numarası</th>
                    <th class="hidden-xs">Bilet Durumu</th>
                    <th class="hidden-xs text-center">Eklenme Tarihi</th>
                    <th class="text-center">Eylem</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $labels['1']['class']   = "label-success";
                $labels['1']['text']    = "Başarılı Ödeme";
                $labels['2']['class']   = "label-info";
                $labels['2']['text']    = "For delivery";
                $labels['0']['class']   = "label-danger";
                $labels['0']['text']    = "Başarısız Ödeme";
                $labels['3']['class']   = "label-warning";
                $labels['3']['text']    = "Processing";

                $orders = $db->query("SELECT ot.name as name,ot.lastname as lastname, ot.price as price, o.order_status,ot.ticket_number,o.id,o.date_added FROM ".DBPREFIX."order_ticket ot LEFT JOIN ".DBPREFIX."order o ON (ot.order_id=o.id) WHERE o.order_status='1'");
                ?>
                <?php foreach($orders->rows as $order) { ?>
                <tr>
                    <td class="text-center"><a href="javascript:;"><strong><?php echo $order['id']; ?></strong></a></td>
                    <td><a href="javascript:;"><?php echo $order['name'].' '.$order['lastname']; ?></a></td>
                    <td class="text-right hidden-xs"><strong><?php echo number_format($order['price'],'2',',','.'); ?>TL</strong></td>
                    <td class="hidden-xs">
                        <a href="javascript:;"><strong><?php echo $order['ticket_number']; ?></strong></a>
                    </td>
                    <td class="hidden-xs">
                        <span class="label<?php $rand = $order['order_status']; echo ($labels[$rand]['class']) ? " " . $labels[$rand]['class'] : ""; ?>"><?php echo ($rand == 1 ? $labels[$rand]['text'] : $labels[$rand]['text'] ); ?></span>
                    </td>
                    <td class="hidden-xs text-center"><?php echo $order['date_added']; ?></td>
                    <td class="text-center">
                        <!--
                        <div class="btn-group btn-group-xs">
                            <a href="<?php echo SITE_ADMIN; ?>ticket_edit.php?ticket_id=<?php echo $order['id']; ?>" data-toggle="tooltip" title="Edit" class="btn btn-default"><i class="fa fa-pencil"></i></a>
                            <a href="javascript:void(0)" data-toggle="tooltip" title="Delete" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></a>
                        </div>
                        -->
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        <!-- END All Products Content -->
    </div>
    <!-- END All Products Block -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/ecomProducts.js"></script>
<script>$(function(){ EcomProducts.init(); });</script>

<?php include 'inc/template_end.php'; ?>