<?php include 'loader.php'; ?>
<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>


<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Orders Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li >
                <a href="<?php echo SITE_ADMIN; ?>index.php"><i class="gi gi-shop_window"></i> Anasayfa</a>
            </li>
            <li class="active">
                <a href="<?php echo SITE_ADMIN; ?>orders.php"><i class="gi gi-notes_2"></i> Randevular</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>customers.php"><i class="fa fa-user"></i> Müşteriler</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>supports.php"><i class="fa fa-ticket"></i> Hizmetler</a>
            </li>
            <li >
                <a href="<?php echo SITE_ADMIN; ?>users.php"><i class="gi gi-certificate"></i> Personel</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>work_plan.php"><i class="gi gi-table"></i> Çalışma Planı</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>reports.php"><i class="fa fa-bar-chart"></i> Raporlar</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Orders Header -->

    <!-- All Orders Block -->
    <div class="block full">
        <!-- All Orders Title -->
        <div class="block-title">
            <div class="block-options pull-right">
                <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Settings"><i class="fa fa-cog"></i></a>
            </div>
            <h2><strong>Tüm</strong> Randevular</h2>
        </div>
        <!-- END All Orders Title -->

        <!-- All Orders Content -->
        <table id="ecom-orders" class="table table-bordered table-striped table-vcenter">
            <thead>
                <tr>
                    <th class="text-center" style="width: 100px;">ID</th>
                    <th class="visible-lg">Müşteri</th>
                    <th class="text-center visible-lg">Telefon</th>
                    <th class="hidden-xs">Randevu Tarihi</th>
                    <th class="text-right hidden-xs">Personel</th>
                    <th>Durum</th>
                    <th class="hidden-xs text-center">Hizmeti</th>
                    <th class="text-center">Eylem</th>
                </tr>
            </thead>
            <tbody>
                <?php

                $labels['3']['class']   = "label-success";
                $labels['3']['text']    = "Başarılı";
                $labels['1']['class']   = "label-info";
                $labels['1']['text']    = "Beklemede";
                $labels['0']['class']   = "label-danger";
                $labels['0']['text']    = "Başarısız Ödeme";
                $labels['2']['class']   = "label-warning";
                $labels['2']['text']    = "İptal Edildi";

                $orders = $db->query("SELECT * FROM ".DBPREFIX."reservations ");
                ?>
                <?php foreach($orders->rows as $order) { ?>
                <tr id="order_id_<?php echo $order['reservation_id']; ?>">
                    <td class="text-center"><a href="<?php echo SITE_ADMIN; ?>order_edit.php?reservation_id=<?php echo $order['reservation_id']; ?>"><strong><?php echo $order['reservation_id']; ?></strong></a></td>
                    <td class="visible-lg"><a href="javascript:void(0)"><?php echo $order['name']; ?></a></td>
                    <td class="text-center visible-lg"><a href="javascript:void(0)"><?php echo $order['telephone']; ?></a></td>
                    <td class="hidden-xs"><?php echo $order['reservation_date']; ?></td>
                    <td class="text-right hidden-xs"><strong><?php echo $func->getUser($order['user_id'],'name'); ?></strong></td>
                    <td><span class="label<?php $rand = $order['status']; echo ($labels[$rand]['class']) ? " " . $labels[$rand]['class'] : ""; ?>"><?php echo $labels[$rand]['text']; ?></span></td>
                    <td class="hidden-xs text-center"><?php echo $order['date_added']; ?></td>
                    <td class="text-center">

                        <div class="btn-group btn-group-xs">
                            <a href="<?php echo SITE_ADMIN; ?>order_edit.php?reservation_id=<?php echo $order['reservation_id']; ?>" data-toggle="tooltip" title="View" class="btn btn-default"><i class="fa fa-eye"></i></a>
                            <a href="javascript:void(0)" onclick="itemDelete('order',<?php echo $order['reservation_id']; ?>);" data-toggle="tooltip" title="Delete" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></a>
                        </div>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        <!-- END All Orders Content -->
    </div>
    <!-- END All Orders Block -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/ecomOrders.js"></script>
<script>$(function(){ EcomOrders.init(); });</script>

<?php include 'inc/template_end.php'; ?>