<?php include 'loader.php'; ?>
<?php include 'inc/config.php'; ?>
<?php include 'inc/template_start.php'; ?>
<?php include 'inc/page_head.php'; ?>
<?php
$labels['1']['class']   = "label-success";
$labels['1']['text']    = "Başarılı Ödeme";
$labels['2']['class']   = "label-info";
$labels['2']['text']    = "Beklemede";
$labels['0']['class']   = "label-danger";
$labels['0']['text']    = "Başarısız Ödeme";
$labels['3']['class']   = "label-warning";
$labels['3']['text']    = "İptal Edildi";

?>


<!-- Page content -->
<div id="page-content">
    <!-- eCommerce Dashboard Header -->
    <div class="content-header">
        <ul class="nav-horizontal text-center">
            <li class="active">
                <a href="<?php echo SITE_ADMIN; ?>index.php"><i class="gi gi-shop_window"></i> Anasayfa</a>
            </li>
            <li >
                <a href="<?php echo SITE_ADMIN; ?>orders.php"><i class="gi gi-notes_2"></i> Randevular</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>customers.php"><i class="fa fa-user"></i> Müşteriler</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>supports.php"><i class="fa fa-ticket"></i> Hizmetler</a>
            </li>
            <li >
                <a href="<?php echo SITE_ADMIN; ?>users.php"><i class="gi gi-certificate"></i> Personel</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>work_plan.php"><i class="gi gi-table"></i> Çalışma Planı</a>
            </li>
            <li>
                <a href="<?php echo SITE_ADMIN; ?>reports.php"><i class="fa fa-bar-chart"></i> Raporlar</a>
            </li>
        </ul>
    </div>
    <!-- END eCommerce Dashboard Header -->

    <!-- Quick Stats -->
    <div class="row text-center">
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background">
                    <h4 class="widget-content-light"><strong>Bekleyen</strong> Randevular</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 animation-expandOpen">
                        <?php
                        $orders = $db->query("SELECT count(reservation_id) as total FROM ".DBPREFIX."reservations WHERE status='1'");
                        echo $orders->row['total'];
                        ?>
                    </span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Tamamlanan</strong> Randevular</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">
                    <?php
                    $orders = $db->query("SELECT count(reservation_id) as total FROM ".DBPREFIX."reservations WHERE status='3'");
                    echo $orders->row['total'];
                    ?>
                    </span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Bugünkü</strong> Randevular</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">
                        <?php
                        $date = date('Y-m-d H:i:s');
                        $date_end = date('Y-m-d 23:59:59');
                        $orders = $db->query("SELECT count(reservation_id) as total FROM ".DBPREFIX."reservations WHERE reservation_date>'".$date."' AND reservation_date<'".$date_end."'");
                        echo $orders->row['total'];
                        ?>
                    </span></div>
            </a>
        </div>
        <div class="col-sm-6 col-lg-3">
            <a href="javascript:void(0)" class="widget widget-hover-effect2">
                <div class="widget-extra themed-background-dark">
                    <h4 class="widget-content-light"><strong>Tüm</strong> Randevular</h4>
                </div>
                <div class="widget-extra-full"><span class="h2 themed-color-dark animation-expandOpen">
                        <?php
                        $orders = $db->query("SELECT count(reservation_id) as total FROM ".DBPREFIX."reservations WHERE status<>'2'");
                        echo $orders->row['total'];
                        ?>
                    </span></div>
            </a>
        </div>
    </div>
    <!-- END Quick Stats -->

    <!-- Orders and Products -->
    <div class="row">
        <div class="col-lg-6">
            <!-- Latest Orders Block -->
            <div class="block">
                <!-- Latest Orders Title -->
                <div class="block-title">
                    <div class="block-options pull-right">
                        <a href="page_ecom_orders.php" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Show All"><i class="fa fa-eye"></i></a>
                        <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Settings"><i class="fa fa-cog"></i></a>
                    </div>
                    <h2><strong>Son 10 </strong> Randevu</h2>
                </div>
                <!-- END Latest Orders Title -->

                <!-- Latest Orders Content -->
                <table class="table table-borderless table-striped table-vcenter table-bordered">
                    <thead>
                    <tr>
                        <th class="text-center" style="width: 100px;">ID</th>
                        <th class="visible-lg">Müşteri</th>
                        <th class="text-center visible-lg">Telefon</th>
                        <th class="hidden-xs">Randevu Tarihi</th>
                        <th class="text-right hidden-xs">Personel</th>
                        <th>Durum</th>
                        <th class="hidden-xs text-center">Hizmeti</th>
                        <th class="text-center">Eylem</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php

                    $labels['3']['class']   = "label-success";
                    $labels['3']['text']    = "Başarılı";
                    $labels['1']['class']   = "label-info";
                    $labels['1']['text']    = "Beklemede";
                    $labels['0']['class']   = "label-danger";
                    $labels['0']['text']    = "Başarısız Ödeme";
                    $labels['2']['class']   = "label-warning";
                    $labels['2']['text']    = "İptal Edildi";

                    $orders = $db->query("SELECT * FROM ".DBPREFIX."reservations ");
                    ?>
                    <?php foreach($orders->rows as $order) { ?>
                        <tr id="order_id_<?php echo $order['reservation_id']; ?>">
                            <td class="text-center"><a href="<?php echo SITE_ADMIN; ?>order_edit.php?reservation_id=<?php echo $order['reservation_id']; ?>"><strong><?php echo $order['reservation_id']; ?></strong></a></td>
                            <td class="visible-lg"><a href="javascript:void(0)"><?php echo $order['name']; ?></a></td>
                            <td class="text-center visible-lg"><a href="javascript:void(0)"><?php echo $order['telephone']; ?></a></td>
                            <td class="hidden-xs"><?php echo $order['reservation_date']; ?></td>
                            <td class="text-right hidden-xs"><strong><?php echo $func->getUser($order['user_id'],'name'); ?></strong></td>
                            <td><span class="label<?php $rand = $order['status']; echo ($labels[$rand]['class']) ? " " . $labels[$rand]['class'] : ""; ?>"><?php echo $labels[$rand]['text']; ?></span></td>
                            <td class="hidden-xs text-center"><?php echo $order['date_added']; ?></td>
                            <td class="text-center">

                                <div class="btn-group btn-group-xs">
                                    <a href="<?php echo SITE_ADMIN; ?>order_edit.php?reservation_id=<?php echo $order['reservation_id']; ?>" data-toggle="tooltip" title="View" class="btn btn-default"><i class="fa fa-eye"></i></a>
                                    <a href="javascript:void(0)" onclick="itemDelete('order',<?php echo $order['reservation_id']; ?>);" data-toggle="tooltip" title="Delete" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></a>
                                </div>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
                <!-- END Latest Orders Content -->
            </div>
            <!-- END Latest Orders Block -->
        </div>
        <div class="col-lg-6">
            <!-- Top Products Block -->
            <div class="block">
                <!-- Top Products Title -->
                <div class="block-title">
                    <div class="block-options pull-right">
                        <a href="page_ecom_products.php" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Show All"><i class="fa fa-eye"></i></a>
                        <a href="javascript:void(0)" class="btn btn-alt btn-sm btn-default" data-toggle="tooltip" title="Settings"><i class="fa fa-cog"></i></a>
                    </div>
                    <h2><strong>Personel</strong> Çalışma Günleri</h2>
                </div>
                <!-- END Top Products Title -->

                <!-- Top Products Content -->
                <table class="table table-borderless table-striped table-vcenter table-bordered">
                    <thead>
                    <tr>
                        <th class="text-center" style="width: 100px;">ID</th>
                        <th class="visible-lg">Personel</th>
                        <th class="visible-lg">Çalışma Günleri</th>
                        <th class="hidden-xs text-center">Durum</th>
                        <th class="text-center">Eylem</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php

                    $orders = $db->query("SELECT * FROM ".DBPREFIX."working_plan ");
                    ?>
                    <?php foreach($orders->rows as $order) { ?>
                        <tr id="working_id_<?php echo $order['working_id']; ?>">
                            <td class="text-center"><a href="<?php echo SITE_ADMIN; ?>new_working.php?working_id=<?php echo $order['working_id']; ?>"><strong><?php echo $order['working_id']; ?></strong></a></td>
                            <td class="visible-lg"><a href="javascript:void(0)"><?php echo $func->getUser($order['user_id'],'name'); ?></a></td>
                            <td class="hidden-xs text-center"><?php $day = $order['day']?unserialize($order['day']):array();
                                if($day){
                                    foreach ($day as $item) {
                                        echo $days[$item].'<br>';
                                    }
                                }
                                ?></td>
                            <td class="hidden-xs text-center"><?php echo $order['status']?'AKtif':'Pasif'; ?></td>
                            <td class="text-center">

                                <div class="btn-group btn-group-xs">
                                    <a href="<?php echo SITE_ADMIN; ?>new_working.php?working_id=<?php echo $order['working_id']; ?>" data-toggle="tooltip" title="View" class="btn btn-default"><i class="fa fa-eye"></i></a>
                                    <a href="javascript:void(0)" onclick="itemDelete('working',<?php echo $order['working_id']; ?>);" data-toggle="tooltip" title="Delete" class="btn btn-xs btn-danger"><i class="fa fa-times"></i></a>
                                </div>
                            </td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
                <!-- END Top Products Content -->
            </div>
            <!-- END Top Products Block -->
        </div>
    </div>
    <!-- END Orders and Products -->
</div>
<!-- END Page Content -->

<?php include 'inc/page_footer.php'; ?>
<?php include 'inc/template_scripts.php'; ?>

<!-- Load and execute javascript code used only in this page -->
<script src="js/pages/ecomDashboard.js"></script>
<script>$(function(){ EcomDashboard.init(); });</script>

<?php include 'inc/template_end.php'; ?>