<?php


namespace FUNCTIONS;


class FUNCTIONS{

    public function prnt($data,$die=false){
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        if ($die) die();
    }

    public function post($post=false){
        //print_r($_POST);
        if($post) {
            return isset($_POST[$post]) ? $_POST[$post] : false;
        }else{
            return $_POST;
        }
    }

    public function get($get){
        //print_r($_POST);
        return isset($_GET[$get])?$_GET[$get]:false;
    }

    function getIP() {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    function location($location = 'index'){

        header('location:'.SITE.$location.'.php');

    }

    function getServer($key){
        return isset($_SERVER[$key])?$_SERVER[$key]:false;
    }

    public function sendMail($mail, $data){

        try {
            //Recipients
            $mail->setFrom(SENDER_MAIL, SENDER_NAME);                           // gönderen
            $mail->addAddress($data['email'], $data['name']);       // Alıcı
            $mail->addReplyTo(SENDER_MAIL, SENDER_NAME);                        // yanıtlanacak adres
            //Content
            $mail->isHTML(true);
            $mail->Subject = $data['subject'];
            $mail->Body    = $data['body'];
            $mail->CharSet = 'UTF-8';
            $mail->send();
            return true;
        } catch (Exception $e) {
            return false;
            /*
            echo 'Message could not be sent.';
            echo 'Mailer Error: ' . $mail->ErrorInfo;
            */
        }

    }

    public function addTicket($transaction_id,$items, $order_info){
        $allitems = array();
        //echo '<pre>';print_r($order_info);die();
        foreach ($items as $item) {
            $allitems[] = array(
                'service_code'  => 1,
                'item_type'     => 'ticket',
                'item_code'     => $item['ticket_id'],
                'person_info'      => array(
                    'first_name'    =>$item['name'],
                    'last_name'     =>$item['lastname'],
                    'phone_number'  =>$item['telephone'],
                    'email_address' =>$item['email'],

                )
            );
        }
        $data = array(
            'transaction_id' => $transaction_id,
            'items' => $allitems,
            'customer_info' => array(
                'name' => $order_info['name'],
                'date_of_birth' => '',
                'email_address' => $order_info['email'],
                'national_id_number' => '',
                'phone_number' => $order_info['telephone'],
            )
        );
        //echo '<pre>';print_r($data);die();
        $curl = curl_init(BARCODES_URL);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER,
            array("Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data));
        $results = curl_exec($curl);
        curl_close($curl);
        $items = array();
        foreach (json_decode($results) as $item) {
            $items[$item->item_code] = $item->code;
        }
        //echo '<pre>';print_r(json_decode($results));die();
        return $items;
    }

    public function sendSms($sms,$number,$message){

       //header('Content-Type: text/plain;charset=utf-8');

        /*
         * Sending one SMS (text) to many cell phone numbers. (1toN)
         * */
        /*
        $to_list = array('905559980448'); // array('38761233976', '00905304012530', '+905364257920');
        $message = 'Bosna i Hercegovina je država u jugoistočnom dijelu Evrope...';
        */

        $from = '';
        $validity_period = 61;
        $data_coding = 'UCS2';
        date_default_timezone_set('UTC');
        $date = mktime(0, 0, 0, 11, 5, 2011); // 5 November 2011
        $scheduled_delivery_time = date(DATE_ATOM, $date); // '2011-11-05T00:00:00+00:00'

        /* Send SMS at 2011-11-05 00:00+01:00, valid for 61 minute and with unicode support */
        // $response = $maradit->submit($to_list, $message, $from, $scheduled_delivery_time, $validity_period, $data_coding);

        $find = array('(',')',' ', '  ', '.','-','+');
        $replace = array('','','','','','','');
        $number = '9'.str_replace($find,$replace,trim($number));
        /* Send SMS immediately, with default sender (from) and  24h validity period, using default GSM 3.38 alphabet */
        $response = $sms->submit(array($number), $message);

        /* Send SMS immediately, with default sender (from) and  24h validity period, with unicode support */
        //$response = $sms->submit($to_list, $message, null, null, null, 'UCS2');

        /*
         * Sending personalized SMS messages. (NtoN)
         * Send immediately, with default sender (from) and  24h validity period, using default GSM 3.38 alphabet.
         * */


        /* Check submit response */
        if($response->status){
            if($response->payload->Status->Code == 200){
                return true;
            }else{
                return false;
            }
        }else{
           return false;
        }

    }
}