<?php
 echo '<pre>'; print_r($_POST);

 ?>
<html>
<head>
    <title>MPI Tester</title>
    <script type="text/javascript" language="javascript">
        /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */
        /*  SHA-1 implementation in JavaScript (c) Chris Veness 2002-2009                                 */
        /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */

        function sha1Hash(msg)
        {
            // constants [§4.2.1]
            var K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];


            // PREPROCESSING

            msg += String.fromCharCode(0x80); // add trailing '1' bit (+ 0's padding) to string [§5.1.1]

            // convert string msg into 512-bit/16-integer blocks arrays of ints [§5.2.1]
            var l = msg.length/4 + 2;  // length (in 32-bit integers) of msg + ‘1’ + appended length
            var N = Math.ceil(l/16);   // number of 16-integer-blocks required to hold 'l' ints
            var M = new Array(N);
            for (var i=0; i<N; i++) {
                M[i] = new Array(16);
                for (var j=0; j<16; j++) {  // encode 4 chars per integer, big-endian encoding
                    M[i][j] = (msg.charCodeAt(i*64+j*4)<<24) | (msg.charCodeAt(i*64+j*4+1)<<16) |
                        (msg.charCodeAt(i*64+j*4+2)<<8) | (msg.charCodeAt(i*64+j*4+3));
                }
            }
            // add length (in bits) into final pair of 32-bit integers (big-endian) [5.1.1]
            // note: most significant word would be (len-1)*8 >>> 32, but since JS converts
            // bitwise-op args to 32 bits, we need to simulate this by arithmetic operators
            M[N-1][14] = ((msg.length-1)*8) / Math.pow(2, 32); M[N-1][14] = Math.floor(M[N-1][14])
            M[N-1][15] = ((msg.length-1)*8) & 0xffffffff;

            // set initial hash value [§5.3.1]
            var H0 = 0x67452301;
            var H1 = 0xefcdab89;
            var H2 = 0x98badcfe;
            var H3 = 0x10325476;
            var H4 = 0xc3d2e1f0;

            // HASH COMPUTATION [§6.1.2]

            var W = new Array(80); var a, b, c, d, e;
            for (var i=0; i<N; i++) {

                // 1 - prepare message schedule 'W'
                for (var t=0;  t<16; t++) W[t] = M[i][t];
                for (var t=16; t<80; t++) W[t] = ROTL(W[t-3] ^ W[t-8] ^ W[t-14] ^ W[t-16], 1);

                // 2 - initialise five working variables a, b, c, d, e with previous hash value
                a = H0; b = H1; c = H2; d = H3; e = H4;

                // 3 - main loop
                for (var t=0; t<80; t++) {
                    var s = Math.floor(t/20); // seq for blocks of 'f' functions and 'K' constants
                    var T = (ROTL(a,5) + f(s,b,c,d) + e + K[s] + W[t]) & 0xffffffff;
                    e = d;
                    d = c;
                    c = ROTL(b, 30);
                    b = a;
                    a = T;
                }

                // 4 - compute the new intermediate hash value
                H0 = (H0+a) & 0xffffffff;  // note 'addition modulo 2^32'
                H1 = (H1+b) & 0xffffffff;
                H2 = (H2+c) & 0xffffffff;
                H3 = (H3+d) & 0xffffffff;
                H4 = (H4+e) & 0xffffffff;
            }

            return H0.toHexStr() + H1.toHexStr() + H2.toHexStr() + H3.toHexStr() + H4.toHexStr();
        }

        //
        // function 'f' [§4.1.1]
        //
        function f(s, x, y, z)
        {
            switch (s) {
                case 0: return (x & y) ^ (~x & z);           // Ch()
                case 1: return x ^ y ^ z;                    // Parity()
                case 2: return (x & y) ^ (x & z) ^ (y & z);  // Maj()
                case 3: return x ^ y ^ z;                    // Parity()
            }
        }

        //
        // rotate left (circular left shift) value x by n positions [§3.2.5]
        //
        function ROTL(x, n)
        {
            return (x<<n) | (x>>>(32-n));
        }

        //
        // extend Number class with a tailored hex-string method
        //   (note toString(16) is implementation-dependant, and
        //   in IE returns signed numbers when used on full words)
        //
        Number.prototype.toHexStr = function()
        {
            var s="", v;
            for (var i=7; i>=0; i--) { v = (this>>>(i*4)) & 0xf; s += v.toString(16); }
            return s;
        }
        /* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */



        function moveWindow() {
            document.myform.submit();
        }

        function hashGenerate(){
            //terminalId + orderid + amount + okurl + failurl + islemtipi + taksit + storekey + provUser.getPasswordText()
            hash = document.getElementById('terminalid').value +
                document.getElementById('orderid').value+
                document.getElementById('txnamount').value+
                document.getElementById('successurl').value+
                document.getElementById('errorurl').value+
                document.getElementById('txntype').value+
                document.getElementById('txninstallmentcount').value+
                "12345678"+
                "6D4159B4134A8F93902EF35AE50A2FE956614BB2";
            document.getElementById('secure3dhash').value= sha1Hash(hash).toUpperCase();
            document.getElementById('testdata').value=document.getElementById('terminalid').value +
                document.getElementById('orderid').value+
                document.getElementById('txnamount').value+
                document.getElementById('successurl').value+
                document.getElementById('errorurl').value+
                document.getElementById('txntype').value+
                document.getElementById('txninstallmentcount').value+
                "12345678"+
                "6D4159B4134A8F93902EF35AE50A2FE956614BB2";

            return true;

        }
    </script>
</head>
<body >
<form action="https://eticaret.garanti.com.tr/destek/postback.aspx" method="post" name="FormGarantiOdemem" id="FormGarantiOdemem">
    <input type="hidden" name="secure3dsecuritylevel" value="CUSTOM_PAY">
    <input name="refreshtime" type="hidden" value="10">
    <input type="hidden" name="orderid" value="DDA2018765678">

    <input type="hidden" name="mode" value="TEST">
    <input type="hidden" name="apiversion" value="v0.01">
    <input type="hidden" name="terminalprovuserid" value="PROVOOS">
    <input type="hidden" name="terminaluserid" value="OZCAN">
    <input type="hidden" name="terminalid" value="30690133">
    <input type="hidden" name="terminalmerchantid" value="3424113">
    <input type="hidden" name="customeremailaddress" value="hsynucak@gmail.com">
    <input type="hidden" name="customeripaddress" value="88.233.248.114">
    <input type="hidden" name="txnamount" value="2950">
    <input type="hidden" name="txncurrencycode" value="949">
    <input type="hidden" name="companyname" value="TEST MAGAZASI">
    <input type="hidden" name="txninstallmentcount" value="">
    <input type="hidden" name="successurl" value="http://www.ddawebdizayn.com/demo/garanti/garanti_success.php">
    <input type="hidden" name="errorurl" value="http://www.ddawebdizayn.com/demo/garanti/garanti_failure.php">
    <input type="hidden" name="secure3dhash" value="B6A39E41B094AF9F1CD052602A3C24A656FCCFBD">
    <input type="hidden" name="lang" value="tr">
    <input type="hidden" name="txntimestamp" value="12.01.2018 17:01:23">
    <input type="hidden" name="garantipay" value="Y">
    <input type="hidden" name="bnsuseflag" value="Y">
    <input type="hidden" name="fbbuseflag" value="N">
    <input type="hidden" name="chequeuseflag" value="N">
    <input type="hidden" name="mileuseflag" value="N">
    <input type="hidden" name="addcampaigninstallment" value="Y">
    <input type="hidden" name="txntype" value="gpdatarequest">
    <input type="hidden" name="txnsubtype" value="sales">
    <input type="hidden" name="totallinstallmentcount" value="4">
    <input type="hidden" name="installmentnumber1" value="2">
    <input type="hidden" name="installmentamount1" value="11000">
    <input type="hidden" name="installmentnumber2" value="4">
    <input type="hidden" name="installmentamount2" value="10000">
    <input type="hidden" name="installmentnumber3" value="6">
    <input type="hidden" name="installmentamount3" value="13000">
    <input type="hidden" name="installmentnumber4" value="7">
    <input type="hidden" name="installmentamount4" value="14000">
    <input id="submit" type="submit" value="submit" />


</form>

<form action="https://sanalposprovtest.garanti.com.tr/servlet/gt3dengine" method="post">
    3D Security Level:
    <select name="secure3dsecuritylevel">
        <option value="CUSTOM_PAY">CUSTOM_PAY</option>
    </select>

    <input name="refreshtime" type="hidden" value="3" />
    <input type="hidden" name="orderid" value="XX102015_" />
    <input id="submit" type="submit" value="submit" />
    <input type="hidden" name="mode" value="TEST" />
    <input type="hidden" name="apiversion" value="v0.01" />
    <input type="hidden" name="terminalprovuserid" value="PROVOOS" />
    <input type="hidden" name="terminaluserid" value="OZCAN" />
    <input type="hidden" name="terminalid" value="30690133" />
    <input type="hidden" name="terminalmerchantid" value="3424113" />
    <input type="hidden" name="customeremailaddress" value="eticaret@garanti.com.tr" />
    <input type="hidden" name="customeripaddress" value="127.0.0.1" />
    <input type="hidden" name="txnamount" value="10000" />
    <input type="hidden" name="txncurrencycode" value="949" />
    <input type="hidden" name="companyname" value="TEST MAGAZASI" />
    <input type="hidden" name="txninstallmentcount" value="" />
    <input type="hidden" name="successurl" value="http://www.ddawebdizayn.com/demo/admin_garanti/index-test.php" />
    <input type="hidden" name="errorurl" value="http://www.ddawebdizayn.com/demo/admin_garanti/index-test.php" />
    <input type="hidden" name="secure3dhash" value="1D053997E32676277CB2AEE1C69399942EA2439D" />
    <input type="hidden" name="lang" value="tr" />
    <input type="hidden" name="txntimestamp" value="12.01.2018 14:01:14" />
    <input type="hidden" name="garantipay" value="Y" />
    <input type="hidden" name="bnsuseflag" value="Y" />
    <input type="hidden" name="fbbuseflag" value="N" />
    <input type="hidden" name="chequeuseflag" value="N" />
    <input type="hidden" name="mileuseflag" value="N" />
    <input type="hidden" name="addcampaigninstallment" value="Y" />
    <input type="hidden" name="txntype" value="gpdatarequest" />
    <input type="hidden" name="txnsubtype" value="sales" />
    <input type="hidden" name="totallinstallmentcount" value="4" />
    <input type="hidden" name="installmentnumber1" value="2" />
    <input type="hidden" name="installmentamount1" value="11000" />
    <input type="hidden" name="installmentnumber2" value="4" />
    <input type="hidden" name="installmentamount2" value="10000" />
    <input type="hidden" name="installmentnumber3" value="6" />
    <input type="hidden" name="installmentamount3" value="13000" />
    <input type="hidden" name="installmentnumber4" value="7" />
    <input type="hidden" name="installmentamount4" value="14000" />
</form>
</body>
</html>

</body>
</html>

